<div {!! $attributes !!}>
    <div class="sm:hidden">
        <x-dropdown width="full" align="top">
            <x-slot:trigger>
                <button type="button"
                    class="relative w-full cursor-default rounded-md border border-slate-300 bg-white py-2 pl-3 pr-10 text-left shadow-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:text-sm dark:border-slate-600 dark:bg-slate-700 dark:text-slate-200 dark:focus:ring-offset-slate-800">
                    @if (request()->routeIs('tenant.settings.general'))
                        {{ t('system') }}
                    @elseif(request()->routeIs('tenant.settings.cache-management'))
                        {{ t('cache_management') }}
                    @elseif(request()->routeIs('tenant.settings.pusher'))
                        {{ t('pusher') }}
                    @elseif(request()->routeIs('tenant.settings.seo'))
                        {{ t('seo') }}
                    @else
                        {{ t('please_select_an_option') }}
                    @endif
                    <span class="pointer-events-none absolute inset-y-0 right-0 ml-3 flex items-center pr-3">
                        <x-heroicon-m-chevron-up-down class="h-5 w-5 text-slate-400" />
                    </span>
                </button>
            </x-slot:trigger>
            <x-slot:content>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.general') }}">
                    {{ t('system') }}
                </x-dropdown-link>

                <x-dropdown-link href="{{ tenant_route('tenant.settings.pusher') }}">
                    {{ t('pusher') }}
                </x-dropdown-link>

                <x-dropdown-link href="{{ tenant_route('tenant.settings.seo') }}">
                    {{ t('seo') }}
                </x-dropdown-link>

                @if (module_exists('CacheManager') && module_enabled('CacheManager'))
                    <x-dropdown-link href="{{ tenant_route('tenant.settings.cache-management') }}">
                        {{ t('cache_management') }}
                    </x-dropdown-link>
                @endif

            </x-slot:content>
        </x-dropdown>
    </div>

    <div class="hidden sm:block">
        <div class="bg-white ring-1 ring-slate-300 sm:rounded-lg dark:bg-transparent dark:ring-slate-600 p-4">
            <div>
                <nav class="flex flex-col gap-1 justify-start" aria-label="Tabs">
                    <!-- General -->
                    <a href="{{ tenant_route('tenant.settings.general') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.general'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.general'),
                    ])>
                        <x-heroicon-o-cog class="w-6 h-6" />
                        <span>{{ t('system') }}</span>
                    </a>

                    <!-- Email Settings -->
                    <a href="{{ tenant_route('tenant.settings.pusher') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.pusher'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.pusher'),
                    ])>
                        <x-heroicon-o-bell-alert class="w-6 h-6" />
                        <span>{{ t('pusher') }}</span>
                    </a>

                    <!-- Seo Settings -->
                    <a href="{{ tenant_route('tenant.settings.seo') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.seo'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.seo'),
                    ])>
                        <x-heroicon-o-arrow-trending-up class="w-6 h-6" />
                        <span>{{ t('seo') }}</span>
                    </a>

                    <!-- Cache Management -->
                    @if (module_exists('CacheManager') && module_enabled('CacheManager'))
                        <a href="{{ tenant_route('tenant.settings.cache-management') }}" @class([
                            'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                            'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                                'tenant.settings.cache-management'),
                            'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                                'tenant.settings.cache-management'),
                        ])>
                            <x-heroicon-o-circle-stack class="w-6 h-6 flex-shrink-0" />
                            <span>{{ t('cache_management') }}</span>
                        </a>
                    @endif
                </nav>
            </div>
        </div>
    </div>

</div>
