<?php

namespace App\Multitenancy;

use Illuminate\Http\Request;
use Spatie\Multitenancy\Models\Tenant;

class PathTenantFinder
{
    public function findForRequest(Request $request): ?Tenant
    {
        $path = $request->path();
        $segments = explode('/', $path);

        if (empty($segments[0])) {
            return null;
        }

        $subdomain = $segments[0];

        // Skip tenant resolution for admin routes
        if (in_array($subdomain, ['admin', 'api', 'login', 'register', 'password', 'install', 'validate'])) {
            return null;
        }

        return Tenant::where('subdomain', $subdomain)->first();
    }
}
