<?php

namespace App\MergeFields\Tenant;

use Illuminate\Support\Facades\Storage;

class OtherMergeFields
{
    public function name(): string
    {
        return 'tenant-other-group';
    }

    public function templates(): array
    {
        return [
            'tenant-email-confirmation',
            'tenants-welcome-mail',
            'tenant-password-reset',
            'tenant-new-contact-assigned',
        ];
    }

    public function build(): array
    {
        return [
            [
                'name' => 'Company Name',
                'key' => '{company_name}',
            ],
            [
                'name' => 'Company Email',
                'key' => '{company_email}',
            ],
            [
                'name' => 'Dark Logo',
                'key' => '{dark_logo}',
                'absent' => [
                    'password-reset',
                ],
            ],
            [
                'name' => 'Light Logo',
                'key' => '{light_logo}',
                'absent' => [
                    'password-reset',
                ],
            ],
            [
                'name' => 'Base Url',
                'key' => '{base_url}',
            ],
        ];
    }

    public function format(): array
    {
        $generalSettings = tenant_settings_by_group('general');

        return [
            '{company_name}' => $generalSettings['site_name'] ?? config('app.name'),
            '{company_email}' => get_tenant_setting_from_db('email', 'sender_email', env('MAIL_FROM_ADDRESS')),
            '{dark_logo}' => ! empty($generalSettings['company_dark_logo']) && Storage::disk('public')->exists($generalSettings['company_dark_logo']) ? asset('storage/'.$generalSettings['company_dark_logo']) : asset('/img/dark_logo.png'),
            '{light_logo}' => ! empty($generalSettings['company_light_logo']) && Storage::disk('public')->exists($generalSettings['company_light_logo']) ? asset('storage/'.$generalSettings['company_light_logo']) : asset('/img/light_logo.png'),
            '{base_url}' => url('/'),
        ];
    }
}
