<?php

use Illuminate\Support\Facades\Route;
use Modules\CacheManager\Services\AdminCacheService;

// Test route for debugging AdminCacheService
Route::get('/test-admin-cache', function () {
    try {
        $service = new AdminCacheService;
        $status = $service->getCacheStatus();

        return response()->json([
            'success' => true,
            'message' => 'AdminCacheService working correctly',
            'data' => $status,
        ]);
    } catch (Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Error: '.$e->getMessage(),
            'trace' => $e->getTraceAsString(),
        ], 500);
    }
});
