<x-app-layout>
    <x-slot:title>
        {{ t('setup_auto_billing') }} - Razorpay
    </x-slot:title>

    <div class="max-w-3xl mx-auto">
        <x-card>
            <x-slot:header>
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                        <x-heroicon-o-credit-card class="w-6 h-6 text-blue-600" />
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900 dark:text-gray-300">
                            {{ t('setup_auto_billing') }}
                        </h2>
                        <p class="text-sm text-gray-500 dark:text-gray-300">
                            {{ t('setup_razorpay_auto_billing_description') }}
                        </p>
                    </div>
                </div>
            </x-slot:header>

            <x-slot:content>
                <div class="text-center py-12">
                    <div class="mx-auto w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                        <x-heroicon-o-information-circle class="w-8 h-8 text-blue-600" />
                    </div>
                    <h3 class="text-lg font-medium text-gray-900 dark:text-gray-300 mb-2">
                        {{ t('auto_billing_setup_required') }}
                    </h3>
                    <p class="text-gray-500 dark:text-gray-400 mb-6">
                        {{ t('razorpay_auto_billing_info') }}
                    </p>

                    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4 mb-6">
                        <p class="text-sm text-blue-800 dark:text-blue-200">
                            {{ t('razorpay_auto_billing_note') }}
                        </p>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <a href="{{ $returnUrl ?? tenant_route('tenant.subscription.dashboard') }}"
                            class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            {{ t('return_to_dashboard') }}
                        </a>
                        <a href="{{ tenant_route('tenant.tickets.index') }}"
                            class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:bg-gray-800 dark:text-gray-300 dark:border-gray-600 dark:hover:bg-gray-700">
                            {{ t('contact_support') }}
                        </a>
                    </div>
                </div>
            </x-slot:content>
        </x-card>
    </div>
</x-app-layout>
