<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>
        WhatsMark
    </title>

    <meta name="description" content="{{ 'WhatsMark' }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Favicon -->
    @php
    
    $settings = get_batch_settings(['theme.favicon']);
        // Get the favicon path from settings
        $faviconPath = $settings['theme.favicon']
            ? Storage::url($settings['theme.favicon'])
            : asset('img/favicon.png');
    @endphp

    <link rel="icon" type="image/png" sizes="32x32" href="{{ $faviconPath }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ $faviconPath }}">
    <link rel="apple-touch-icon" href="{{ $faviconPath }}">

    <!-- Styles -->
    @livewireStyles
    @vite('resources/css/app.css')

</head>

<body class="font-sans text-gray-900 antialiased">
    <div class="min-h-screen flex flex-col sm:justify-center items-center sm:pt-0 bg-gray-100 dark:bg-gray-900">
        <div {{ $attributes->merge(['class' => ' bg-indigo-50 dark:bg-gray-800 overflow-hidden w-full']) }}>
            {{ $slot }}
        </div>
    </div>
    <x-notification />

    <!-- Scripts -->
    @livewireScripts

    @vite('resources/js/app.js')
    @stack('scripts')
</body>

</html>
