<div {!! $attributes !!}>
    <div class="sm:hidden">
        <x-dropdown width="full" align="top">
            <x-slot:trigger>
                <button type="button"
                    class="relative w-full cursor-default rounded-md border border-slate-300 bg-white py-2 pl-3 pr-10 text-left shadow-sm focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:text-sm dark:border-slate-600 dark:bg-slate-700 dark:text-slate-200 dark:focus:ring-offset-slate-800">
                    @if (request()->routeIs('tenant.settings.whatsapp-auto-lead'))
                        {{ t('whatsapp_auto_lead') }}
                    @elseif(request()->routeIs('tenant.settings.stop-bot'))
                        {{ t('stop_bot') }}
                    @elseif(request()->routeIs('tenant.settings.whatsapp-web-hooks'))
                        {{ t('web_hooks') }}
                    @elseif(request()->routeIs('tenant.settings.support-agent'))
                        {{ t('support_agent') }}
                    @elseif(request()->routeIs('tenant.settings.notification-sound'))
                        {{ t('notification_sound') }}
                    @elseif(request()->routeIs('tenant.settings.ai-integration'))
                        {{ t('ai_integration') }}
                    @elseif(request()->routeIs('tenant.settings.auto-clear-chat-history'))
                        {{ t('auto_clear_chat_history') }}
                    @else
                        {{ t('please_select_an_option') }}
                    @endif
                    <span class="pointer-events-none absolute inset-y-0 right-0 ml-3 flex items-center pr-3">
                        <x-heroicon-m-chevron-up-down class="h-5 w-5 text-slate-400" />
                    </span>
                </button>
            </x-slot:trigger>
            <x-slot:content>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.whatsapp-auto-lead') }}">
                    {{ t('whatsapp_auto_lead') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.stop-bot') }}">
                    {{ t('stop_bot') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.whatsapp-web-hooks') }}">
                    {{ t('web_hooks') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.support-agent') }}">
                    {{ t('support_agent') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.notification-sound') }}">
                    {{ t('notification_sound') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.ai-integration') }}">
                    {{ t('ai_integration') }}
                </x-dropdown-link>
                <x-dropdown-link href="{{ tenant_route('tenant.settings.auto-clear-chat-history') }}">
                    {{ t('auto_clear_chat_history') }}
                </x-dropdown-link>
            </x-slot:content>
        </x-dropdown>
    </div>

    <div class="hidden sm:block">
        <div class="bg-white ring-1 ring-slate-300 sm:rounded-lg dark:bg-transparent dark:ring-slate-600 p-4">
            <div>
                <nav class="flex flex-col gap-1 justify-start" aria-label="Tabs">
                    <!-- WhatsappAutoLead -->
                    <a href="{{ tenant_route('tenant.settings.whatsapp-auto-lead') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.whatsapp-auto-lead'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.whatsapp-auto-lead'),
                    ])>
                        <x-heroicon-o-chat-bubble-bottom-center-text class="w-6 h-6 md:flex-none" />
                        <span>{{ t('whatsapp_auto_lead') }}</span>
                    </a>
                    <!-- StopBot Settings -->
                    <a href="{{ tenant_route('tenant.settings.stop-bot') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.stop-bot'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.stop-bot'),
                    ])>
                        <x-heroicon-o-shield-check class="w-6 h-6 md:flex-none" />
                        <span>{{ t('stop_bot') }}</span>
                    </a>

                    <!-- Re-captcha -->
                    <a href="{{ tenant_route('tenant.settings.whatsapp-web-hooks') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.whatsapp-web-hooks'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.whatsapp-web-hooks'),
                    ])>
                        <x-heroicon-o-arrow-path-rounded-square class="w-6 h-6 md:flex-none" />
                        <span>{{ t('web_hooks') }}</span>
                    </a>

                    <!-- SupportAgent -->
                    <a href="{{ tenant_route('tenant.settings.support-agent') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.support-agent'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.support-agent'),
                    ])>
                        <x-heroicon-o-megaphone class="w-6 h-6 md:flex-none" />
                        <span>{{ t('support_agent') }}</span>
                    </a>

                    <!-- NotificationSound -->
                    <a href="{{ tenant_route('tenant.settings.notification-sound') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b  font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.notification-sound'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.notification-sound'),
                    ])>
                        <x-heroicon-o-bell-alert class="w-6 h-6 md:flex-none" />
                        <span>{{ t('notification_sound') }}</span>
                    </a>

                    <!-- AiIntegration -->
                    <a href="{{ tenant_route('tenant.settings.ai-integration') }}" @class([
                        'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md border-b  font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                        'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                            'tenant.settings.ai-integration'),
                        'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                            'tenant.settings.ai-integration'),
                    ])>
                        <x-heroicon-o-cpu-chip class="w-6 h-6 md:flex-none" />
                        <span>{{ t('ai_integration') }}</span>
                    </a>

                    <!-- AutoClearChatHistory -->
                    <a href="{{ tenant_route('tenant.settings.auto-clear-chat-history') }}"
                        @class([
                            'flex items-center space-x-3 text-sm p-1 py-2 rounded-t-md font-medium hover:bg-gray-50 dark:hover:bg-slate-800',
                            'text-indigo-600 dark:bg-slate-800' => request()->routeIs(
                                'tenant.settings.auto-clear-chat-history'),
                            'border-slate-200 text-slate-500 hover:text-slate-700 hover:border-slate-300 dark:border-slate-600 dark:text-slate-400 dark:hover:text-slate-300' => !request()->routeIs(
                                'tenant.settings.auto-clear-chat-history'),
                        ])>

                        <x-heroicon-o-trash class="w-6 h-6 md:flex-none" />
                        <span>{{ t('auto_clear_chat_history') }}</span>
                    </a>

                </nav>
            </div>
        </div>
    </div>

</div>
