<?php

namespace App\Http\Middleware;

use App\Models\Tenant;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureTenantSecurity
{
    /**
     * Handle an incoming request.
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Skip if no tenant or no authenticated user
        if (! Tenant::checkCurrent() || ! Auth::check()) {
            return response()->view('errors.404', [], 404);
        }

        $user = Auth::user();
        $tenant = Tenant::current();

        // Check if user belongs to current tenant or is super admin
        if ($user->tenant_id !== $tenant->id && ! $user->is_admin) {
            return response()->json(['message' => 'Unauthorized'], 403);
        }

        // Check if tenant is active
        if ($tenant->status !== 'active') {

            session()->flash('notification', [
                'type' => 'warning',
                'message' => "Your account is currently {$tenant->status} You can still create support tickets.",
            ]);

            return redirect()->to(tenant_route('tenant.tickets.index'));
        }

        return $next($request);
    }
}
