<?php

namespace App\Livewire\Tenant\Settings\System;

use App\Rules\PurifiedInput;
use Livewire\Component;

class SeoSettings extends Component
{
    public ?string $meta_title = '';

    public ?string $meta_description = '';

    protected function rules()
    {
        return [
            'meta_title' => ['nullable', 'string', new PurifiedInput(t('sql_injection_error'))],
            'meta_description' => ['nullable', 'string', new PurifiedInput(t('sql_injection_error'))],

        ];
    }

    public function mount()
    {
        if (! checkPermission('tenant.system_settings.view')) {
            $this->notify(['type' => 'danger', 'message' => t('access_denied_note')], true);

            return redirect(tenant_route('tenant.dashboard'));
        }

        $settings = tenant_settings_by_group('seo');

        $this->meta_title = $settings['meta_title'] ?? false;
        $this->meta_description = $settings['meta_description'] ?? '';
    }

    public function save()
    {
        if (checkPermission('tenant.system_settings.edit')) {
            $this->validate();

            $originalSettings = tenant_settings_by_group('seo');

            $newSettings = [
                'meta_title' => $this->meta_title,
                'meta_description' => $this->meta_description,
            ];

            // Filter only modified or undefined settings
            $modifiedSettings = array_filter($newSettings, function ($value, $key) use ($originalSettings) {
                return ! array_key_exists($key, $originalSettings) || $originalSettings[$key] !== $value;
            }, ARRAY_FILTER_USE_BOTH);

            if (! empty($modifiedSettings)) {
                foreach ($modifiedSettings as $key => $value) {
                    save_tenant_setting('seo', $key, $value);
                }

                $this->notify(['type' => 'success', 'message' => t('setting_save_successfully')]);
            }
        }
    }

    public function render()
    {
        return view('livewire.tenant.settings.system.seo-settings');
    }
}
