<?php

namespace App\Enum;

enum TenantStatus: string
{
    case DEACTIVE = 'deactive';
    case ACTIVE = 'active';
    case SUSPENDED = 'suspended';

    public function label(): string
    {
        return match ($this) {
            self::DEACTIVE => 'Deactive',
            self::ACTIVE => 'Active',
            self::SUSPENDED => 'Suspended',
        };
    }

    public function colors(): array
    {
        return match ($this) {
            self::ACTIVE => [
                'bg' => 'bg-green-50 dark:bg-green-900/10',
                'text' => 'text-green-700 dark:text-green-400',
                'dot' => 'bg-green-500',
                'border' => 'border-green-200 dark:border-green-800',
            ],
            self::DEACTIVE => [
                'bg' => 'bg-gray-50 dark:bg-gray-800/60',
                'text' => 'text-gray-700 dark:text-gray-400',
                'dot' => 'bg-gray-400',
                'border' => 'border-gray-200 dark:border-gray-700',
            ],
            self::SUSPENDED => [
                'bg' => 'bg-yellow-50 dark:bg-yellow-900/10',
                'text' => 'text-yellow-700 dark:text-yellow-400',
                'dot' => 'bg-yellow-500',
                'border' => 'border-yellow-200 dark:border-yellow-800',
            ],
            
        };
    }

    public static function labels(): array
    {
        return array_column(array_map(
            fn ($case) => ['value' => $case->value, 'label' => $case->label()],
            self::cases()
        ), 'label', 'value');
    }

    public static function colorMap(): array
    {
        $result = [];
        foreach (self::cases() as $case) {
            $result[$case->value] = $case->colors();
        }

        return $result;
    }

    public static function defaultColors(): array
    {
        return [
            'bg' => 'bg-indigo-50 dark:bg-indigo-900/10',
            'text' => 'text-indigo-700 dark:text-indigo-400',
            'dot' => 'bg-indigo-500',
            'border' => 'border-indigo-200 dark:border-indigo-800',
        ];
    }
}
